/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.block.crops;

import cloud.lemonslice.teastory.block.crops.TrellisWithVineBlock;
import cloud.lemonslice.teastory.block.crops.VineType;
import cloud.lemonslice.teastory.helper.VoxelShapeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public class StemFruitBlock
extends Block
implements BonemealableBlock,
IPlantable {
    public final VineType type;
    public static final IntegerProperty AGE_0_4 = IntegerProperty.m_61631_((String)"age", (int)0, (int)4);
    private static final VoxelShape SHAPE = VoxelShapeHelper.createVoxelShape(3.5, 6.0, 3.5, 9.0, 10.0, 9.0);

    public StemFruitBlock(VineType type, BlockBehaviour.Properties properties) {
        super(properties);
        this.type = type;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)AGE_0_4, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.m_7494_();
        BlockState up = worldIn.m_8055_(blockpos);
        return state.m_60734_() == this && up.m_60734_() instanceof TrellisWithVineBlock && ((TrellisWithVineBlock)up.m_60734_()).getType() == this.type;
    }

    public BlockState m_7417_(BlockState stateIn, Direction pDirection, BlockState pNeighborState, LevelAccessor worldIn, BlockPos currentPos, BlockPos pNeighborPos) {
        if (this.m_7898_(stateIn, (LevelReader)worldIn, currentPos)) {
            return stateIn;
        }
        return Blocks.f_50016_.m_49966_();
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        float f;
        int i;
        super.m_213897_(state, worldIn, pos, rand);
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (worldIn.m_45524_(pos, 0) >= 9 && (i = ((Integer)state.m_61143_((Property)AGE_0_4)).intValue()) < 4 && ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)state, (rand.m_188503_((int)(25.0f / (f = StemFruitBlock.getGrowthChance(this, worldIn, pos, this.type))) + 1) == 0 ? 1 : 0) != 0)) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE_0_4, (Comparable)Integer.valueOf(i + 1)), 2);
            ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    protected static float getGrowthChance(Block blockIn, ServerLevel worldIn, BlockPos pos, VineType type) {
        boolean flag1;
        float f = 1.0f;
        BlockPos blockpos = pos.m_7494_();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                BlockState blockstate = worldIn.m_8055_(blockpos.m_7918_(i, 0, j));
                if (blockstate.m_60734_() instanceof TrellisWithVineBlock && ((TrellisWithVineBlock)blockstate.m_60734_()).getType() == type) {
                    f1 = 1.0f;
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos1 = pos.m_122012_();
        BlockPos blockpos2 = pos.m_122019_();
        BlockPos blockpos3 = pos.m_122024_();
        BlockPos blockpos4 = pos.m_122029_();
        boolean flag = blockIn == worldIn.m_8055_(blockpos3).m_60734_() || blockIn == worldIn.m_8055_(blockpos4).m_60734_();
        boolean bl = flag1 = blockIn == worldIn.m_8055_(blockpos1).m_60734_() || blockIn == worldIn.m_8055_(blockpos2).m_60734_();
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = blockIn == worldIn.m_8055_(blockpos3.m_122012_()).m_60734_() || blockIn == worldIn.m_8055_(blockpos4.m_122012_()).m_60734_() || blockIn == worldIn.m_8055_(blockpos4.m_122019_()).m_60734_() || blockIn == worldIn.m_8055_(blockpos3.m_122019_()).m_60734_();
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f / 2.0f;
    }

    public boolean m_7370_(LevelReader pLevel, BlockPos pPos, BlockState state, boolean pIsClient) {
        return (Integer)state.m_61143_((Property)AGE_0_4) < 4;
    }

    public boolean m_214167_(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    public void m_214148_(ServerLevel worldIn, RandomSource pRandom, BlockPos pos, BlockState state) {
        int i = (Integer)state.m_61143_((Property)AGE_0_4) + 2;
        if (i > 4) {
            i = 4;
        }
        worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE_0_4, (Comparable)Integer.valueOf(i)), 2);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{AGE_0_4}));
    }

    public BlockState getPlant(BlockGetter world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() != this) {
            return this.m_49966_();
        }
        return state;
    }
}

